﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Microsoft.Reporting.WinForms;
using System.IO;
using System.Xml;

namespace EksportPDF
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            // TODO: This line of code loads data into the 'northwindDataSet.Categories' table. You can move, or remove it, as needed.
            this.categoriesTableAdapter.Fill(this.northwindDataSet.Categories);

            reportViewer1.LocalReport.ReportPath = "Report1.rdlc";                           
            reportViewer1.LocalReport.DataSources.Add(new ReportDataSource("Categories", 
                (DataTable)northwindDataSet.Categories));

            dataGridView1.AutoResizeRows();
            dataGridView1.AutoResizeColumns();

            ustawStanKontrolek();

            this.reportViewer1.RefreshReport();
        }

        private void ustawStanKontrolek(bool odblokowane = false)
        {
            button1.Enabled = odblokowane;
            button2.Enabled = odblokowane;            
        }

        private void button1_Click(object sender, EventArgs e)
        {
            string filtr;
            switch (comboBox1.Text)
            {
                case "PDF" :
                    filtr = "Pliki PDF (*.pdf)|*.pdf";
                    break;
                case "Word" :
                    filtr = "Dokumenty Word (*.doc)|*.doc";
                    break;
                case "Excel" :
                    filtr = "Skoroszyty kalkulacyjne Excel (*.xls)|*.xls";
                    break;
                default:
                    filtr = "*.*";
                    break;
            }
            
            saveFileDialog1.Filter = filtr;
            saveFileDialog1.FileName = "Raport" + filtr.Substring(filtr.Length-4);
 
            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox1.Text = saveFileDialog1.FileName;
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {            
            string typPliku = comboBox1.Text, 
                nazwaPliku = textBox1.Text;
            
            try
            {
                byte[] bytes = reportViewer1.LocalReport.Render(typPliku, null);
                FileStream fs = new FileStream(nazwaPliku, FileMode.OpenOrCreate);
                fs.Write(bytes, 0, bytes.Length);
                fs.Close();

                ustawStanKontrolek();
                MessageBox.Show("Pomyślnie wyeksportowano dane do pliku: " + nazwaPliku, "Eksport");
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }                           
        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            bool czyDokonanoPoprawnegoWyboru = false;
            foreach(string s in comboBox1.Items)
                if(s == comboBox1.Text)
                    czyDokonanoPoprawnegoWyboru = true;

            if(czyDokonanoPoprawnegoWyboru)
                ustawStanKontrolek(true);
            else
                ustawStanKontrolek();
        }
    }
}
